IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].ufd_calcular_difal_basedupla') AND TYPE IN (N'FN', N'IF', N'TF', N'FS', N'FT'))
    DROP FUNCTION [DBO].ufd_calcular_difal_basedupla
GO 

CREATE FUNCTION dbo.ufd_calcular_difal_basedupla(
    @VlrBaseIcms DECIMAL(18,4),
    @VlrIcms DECIMAL(18,4),
    @PercIcmsDestinoDifal DECIMAL(18,4),
    @PercFecop DECIMAL(18,4)
)
RETURNS @Resultado TABLE (
    BaseIcmsDestinoDifal DECIMAL(18,4),
    ValorIcmsDestinoDifal DECIMAL(18,4),
    VlrBaseFecop DECIMAL(18,4),
    VlrFecop DECIMAL(18,4)
)
AS
BEGIN
    DECLARE @AliqIcmsDest DECIMAL(18,4), 
            @BaseIcms DECIMAL(18,4),
            @VlrIcmsInternoDestino DECIMAL(18,4),
            @VlrDifalItem DECIMAL(18,4),
            @PercFecopFuncao DECIMAL(18,4),
            @VlrFecop DECIMAL(18,4);

    -- Convertendo percentuais para fração decimal
    SET @AliqIcmsDest = @PercIcmsDestinoDifal / 100;
    SET @PercFecopFuncao = @PercFecop / 100;

    -- Cálculo da Base de ICMS ajustada
    SET @BaseIcms = (@VlrBaseIcms - @VlrIcms) / (1 - @AliqIcmsDest);

    -- Cálculo do ICMS interno no destino
    SET @VlrIcmsInternoDestino = @BaseIcms * @AliqIcmsDest;

    -- Cálculo do DIFAL
    SET @VlrDifalItem = @VlrIcmsInternoDestino - @VlrIcms;

    -- Cálculo do FECOP
    SET @VlrFecop = @BaseIcms * @PercFecopFuncao;

    -- Inserindo os valores na tabela de retorno
    INSERT INTO @Resultado (BaseIcmsDestinoDifal, ValorIcmsDestinoDifal, VlrBaseFecop, VlrFecop)
    VALUES (@BaseIcms, @VlrDifalItem, @BaseIcms, @VlrFecop);

    RETURN;
END;
